# Contributing to UT-ECE-Student-Resources

Thank you for considering contributing to our repository! Here are some guidelines to help you get started.

## How to Contribute

1. Fork the repository.
2. Create a new branch for your feature or fix.
3. Make your changes and commit them.
4. Push your changes to your fork.
5. Submit a pull request.

## Guidelines

- Follow the style of the project.
- Write clear and concise commit messages.
- Provide a detailed description of your changes in the pull request.

## Example Process for Contributors:

1. **Fork the Repository**: Fork the repository to your own GitHub account.
2. **Clone the Fork**: Clone your forked repository to your local machine.
    ```bash
    git clone https://github.com/moshafieeha/UT-ECE-Student-Resources.git
    cd UT-ECE-Student-Resources
    ```
3. **Create a New Branch**: Create a new branch for the feature or fix.
    ```bash
    git checkout -b feature/your-feature-name
    ```
4. **Make Changes**: Make your changes and commit them.
    ```bash
    git add .
    git commit -m "Add a meaningful commit message"
    ```
5. **Push to Fork**: Push your branch to your forked repository.
    ```bash
    git push origin feature/your-feature-name
    ```
6. **Submit a Pull Request**: Go to the original repository and submit a pull request from your branch.

## Need Help?

If you have any questions or need assistance, feel free to open an issue or contact us at [email](mailto:m.shafieeha@gmail.com).

